using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class SURVEYSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SURVEYSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public SURVEYS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SURVEYS_ID)
        {
            SURVEYS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SURVEYS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, SURVEYS_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<SURVEYS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<SURVEYS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SURVEYS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, SURVEYS objSave)
        {
            Int32? objReturn = objSave.SURVEYS_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_SURVEYS_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.AUTHOR_DUZ, objSave.AUTHOR_ID, DateTime.Now, objSave.CREATEDBY, objSave.PATIENT_ID, objSave.PROVIDER_DUZ, objSave.PROVIDER_ID, objSave.STD_SURVEY_TYPE_ID, objSave.SURVEY_DATE, objSave.SURVEY_STATUS, ref objReturn, DateTime.Now, objSave.UPDATEDBY);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SURVEYS_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_SURVEYS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, SURVEYS_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<SURVEYS> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<SURVEYS> objReturn = null;
            List<STD_SURVEY_TYPE> objTemp = null;

            //TODO: Revisit

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);

                    //objReturn = dbContext.usp_SURVEYS_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = dbContext.usp_STD_SURVEY_TYPE_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    objTemp = objTemp.Where(r => r.STD_REGISTRY_ID == CURRENT_REGISTRY_ID).ToList();
                    objReturn = dbContext.usp_SURVEYS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objReturn != null && objTemp != null)
                        objReturn = (from s in objReturn where (from t in objTemp select t.ID).Contains(s.STD_SURVEY_TYPE_ID) select s).ToList();

                    if (objReturn != null)
                    {
                        foreach (SURVEYS s in objReturn)
                        {
                            if (s.PATIENT_ID > 0)
                            {
                                s.PATIENT = dbContext.usp_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, s.PATIENT_ID).FirstOrDefault();
                            }

                            if (s.STD_SURVEY_TYPE_ID > 0)
                            {
                                s.STD_SURVEY_TYPE = dbContext.usp_STD_SURVEY_TYPE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, s.STD_SURVEY_TYPE_ID).FirstOrDefault();
                            }

                            if (s.PROVIDER_ID != null && s.PROVIDER_ID.Value > 0)
                            {
                                s.SStaff_SStaff = dbContext.usp_SStaff_SStaff_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, s.PROVIDER_ID.Value).FirstOrDefault();
                            }
                        }
                    }

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

		#endregion
	}
}
